/* Mode: C; Tab-Width: 4.; */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    */
/*  All rights reserved.                                                 */
/*                                                                       */
/*
	Serial.h - Serial Driver

	C Interface to the Macintosh Libraries
	Copyright Apple Computer,Inc. 1985-1987
	All rights reserved.
	
	Completed 10.20.87 MBC @TI Austin.  Added Pascal procedure defs.
*/

#ifndef __SERIAL__
#define __SERIAL__
#ifndef __TYPES__
#include <Types.h>
#endif

#define baud300 380
#define baud600 189
#define baud1200 94
#define baud1800 62
#define baud2400 46
#define baud3600 30
#define baud4800 22
#define baud7200 14
#define baud9600 10
#define baud19200 4
#define baud57600 0
#define stop10 16384
#define stop15 (-32768)
#define stop20 (-16384)
#define noParity 0
#define oddParity 4096
#define evenParity 12288
#define data5 0
#define data6 2048
#define data7 1024
#define data8 3072
#define ctsEvent 32
#define breakEvent 128
#define xOffWasSent 0x80
#define dtrNegated 0x40

	  /* refNums from the serial ports */
#define ainRefNum  -6 	/* serial port A input */
#define aoutRefNum -7 /* serial port A output */
#define binRefNum  -8 	/* serial port B input */
#define boutRefNum -9 /* serial port B output */

enum {
	sPortA,
	sPortB
};
typedef unsigned char SPortSel;
typedef struct SerShk {
	char fXOn;
	char fCTS;
	unsigned char xOn;
	unsigned char xOff;
	char errs;
	char evts;
	char fInX;
	char fDTR;
} SerShk;
typedef struct SerStaRec {
	char cumErrs;
	char xOffSent;
	char rdPend;
	char wrPend;
	char ctsHold;
	char xOffHold;
} SerStaRec;

pascal OSErr OPENDRIVER(name,drvrRefNum)
	Str255 *name;
	short *drvrRefNum;
	extern;

pascal OSErr RAMSDOpen(whichPort)
	SPortSel whichPort;
	extern;

pascal void RAMSDClose(whichPort)
	SPortSel whichPort;
	extern;
	
pascal OSErr SerReset(refnum,serConfig)
	short refnum;
	short serConfig;	
	extern;

pascal OSErr SerSetBuf(refnum,serBPtr,serBLen)
	short refnum;
	Ptr serBPtr;
	short serBLen;
	extern;
	
pascal OSErr SerHShake(refnum,flags)
	short refnum;
	SerShk *flags;
	extern;

pascal OSErr SerSetBrk(refnum)
	short refnum;
	extern;

pascal OSErr SerClrBrk(refnum)
	short refnum;
	extern;
	
pascal OSErr SerGetBuf(refNum,count)
	short refNum;
	long *count;
	extern;

pascal void SerStatus(refNum,serSta)
	short refNum;
	SerStaRec *serSta;
	extern;
	
#endif
